Attribute VB_Name = "Codice"
Option Explicit

Public Keys(255) As Boolean
Private hrc As Long
Private fullscreen As Boolean

Private mPointerCount As Integer


Dim LightAmbient(3) As GLfloat
Dim LightDiffuse(3) As GLfloat
Dim LightPosition(3) As GLfloat

Dim quadratic As GLUquadricObj

Dim yrot As GLfloat


Const brick_orientation_x = 0   'pezzo allineato all'asse x
Const brick_orientation_z = 1   'pezzo allineato all'asse y

Const brick_size_flat = 0.32    'altezza di un mattoncino piatto (1/3 rispetto a quella di un mattoncino normale)
Const brick_size_normal = 0.96  'altezza di un mattoncino normale

Type brick  'definizione del tipo brick (mattoncino) che tiene le informazioni su un mattoncino
    orientation As Integer  'orientamento (orientato all'asse x o all'asse z)
    x As GLfloat    'coordinate del mattoncino
    y As GLfloat
    z As GLfloat
    enabled As Boolean  'variabile per il controllo sul movimento del mattoncino
    visible As Boolean  'variabile che serve per decidere se mostrare o meno il mattoncino
    red As GLfloat  'colori del mattoncino
    green As GLfloat
    blue As GLfloat
End Type

Dim LEGO_brick As GLuint    'contenitore per la display list dei mattoncini
Dim LEGO_base As GLuint 'contenitore per la display list deilla base

Dim bricks(100) As brick    'array che contiene le informazioni su tutti i mattoncini




Private Sub HidePointer()
'nascondo il cursore del mouse
mPointerCount = ShowCursor(False) + 1
Do While ShowCursor(False) >= -1
Loop
Do While ShowCursor(True) <= -1
Loop
ShowCursor False
End Sub

Private Sub ShowPointer()
'mostro il cursore del mouse
Do While ShowCursor(False) >= mPointerCount
Loop
Do While ShowCursor(True) <= mPointerCount
Loop
End Sub

Public Sub ReSizeGLScene(ByVal Width As GLsizei, ByVal Height As GLsizei)
'ridimensiono ed inizializzo il form
If Height = 0 Then  'serve per evitare una divisione per zero
    Height = 1
End If

glViewport 0, 0, Width, Height  'resetto il punto di vista corrente
glMatrixMode mmProjection   'seleziono la matrice di proiezione
glLoadIdentity  'e la resetto

gluPerspective 60#, Width / Height, 0.1, 100#   'setto la scala della scena

glMatrixMode mmModelView    'seleziono la matrice modelview
glLoadIdentity  'e la resetto
End Sub

Public Function InitGL() As Boolean
' Funzione che attiva le impostazioni iniziali delle OpenGL
glShadeModel smSmooth

glClearColor 0, 0, 0, 0 'setta lo sfondo a nero

glClearDepth 1
glEnable glcDepthTest
glEnable glcLighting    'attiva i riflessi di luce
glEnable glcColorMaterial   'attiva il colore in presenza dei riflessi (alrimenti tutti i mattoncini sarebbero bianchi)
glDepthFunc cfLEqual
glHint htPerspectiveCorrectionHint, hmNicest

'setto le informazioni sulla fonte di luce
'la potenza della luce ambientale
LightAmbient(0) = 0.5: LightAmbient(1) = 0.5: LightAmbient(2) = 0.5: LightAmbient(3) = 1
'la potenza della luce diffusa
LightDiffuse(0) = 0.5: LightDiffuse(1) = 0.5: LightDiffuse(2) = 0.5: LightDiffuse(3) = 0.5
'e la posizione della luce
LightPosition(0) = 0: LightPosition(1) = -5: LightPosition(2) = -2: LightPosition(3) = 1

'abilito la fonte di luce dopo averla impostata
glLightfv ltLight1, lpmAmbient, LightAmbient(0)
glLightfv ltLight1, lpmDiffuse, LightDiffuse(0)
glLightfv ltLight1, lpmPosition, LightPosition(0)
glEnable glcLight1

'configuro un quadric, una struttura nella quale possono essere inserite delle informazioni su un solido
'in modo pi comodo rispetto al semplice disegno delle varie facce
quadratic = gluNewQuadric()
gluQuadricNormals quadratic, qnSmooth
gluQuadricTexture quadratic, GL_TRUE

Randomizza  'richiamo la funzione che inizializza l'array con le informazioni sui mattoncini

InitDisplayList 'richiamo la funzione che inizializza le display list

InitGL = True   'in questo caso la funzione InitGL non pu fallire
End Function


Public Sub KillGLWindow()
If fullscreen Then
    ShowPointer 'mostro il cursore nuovamente
End If

If hrc Then 'se esiste ancora un Rendering Context
    If wglMakeCurrent(0, 0) = 0 Then    'cerco di rilasciare il Rendering Context ed il Device Context
        MsgBox "Impossibile rilasciare il RC ed il DC", vbInformation, "SHUTDOWN ERROR"
    End If

    If wglDeleteContext(hrc) = 0 Then    'cerco di eliminare il Rendering Context
        MsgBox "Impossibile eliminare il Rendering Context", vbInformation, "SHUTDOWN ERROR"
    End If
    hrc = 0 'setto a NULL l'handle (un puntatore) al Rendering Context
End If
End Sub

Public Function CreateGLWindow(frm As Form, Width As Integer, Height As Integer, Bits As Integer, fullscreenflag As Boolean) As Boolean
Dim PixelFormat As GLuint
Dim pfd As PIXELFORMATDESCRIPTOR

CreateGLWindow = True
fullscreen = fullscreenflag

'setto le informazioni per il pixel format
pfd.cAccumAlphaBits = 0
pfd.cAccumBits = 0
pfd.cAccumBlueBits = 0
pfd.cAccumGreenBits = 0
pfd.cAccumRedBits = 0
pfd.cAlphaBits = 0
pfd.cAlphaShift = 0
pfd.cAuxBuffers = 0
pfd.cBlueBits = 0
pfd.cBlueShift = 0
pfd.cColorBits = Bits
pfd.cDepthBits = 16
pfd.cGreenBits = 0
pfd.cGreenShift = 0
pfd.cRedBits = 0
pfd.cRedShift = 0
pfd.cStencilBits = 0
pfd.dwDamageMask = 0
pfd.dwFlags = PFD_DRAW_TO_WINDOW Or PFD_SUPPORT_OPENGL Or PFD_DOUBLEBUFFER
pfd.dwLayerMask = 0
pfd.dwVisibleMask = 0
pfd.iLayerType = PFD_MAIN_PLANE
pfd.iPixelType = PFD_TYPE_RGBA
pfd.nSize = Len(pfd)
pfd.nVersion = 1

PixelFormat = ChoosePixelFormat(frm.hDC, pfd)   'chiedo a windows di darmi un pixel format adatto
If PixelFormat = 0 Then
    KillGLWindow    'elimino il form
    MsgBox "Can't Find A Suitable PixelFormat.", vbExclamation, "ERROR"
    CreateGLWindow = False
End If

If SetPixelFormat(frm.hDC, PixelFormat, pfd) = 0 Then   'setto il Pixel Format sul form
    KillGLWindow    'elimino il form
    MsgBox "Impossibile settare il Pixel Format", vbExclamation, "ERROR"
    CreateGLWindow = False
End If

hrc = wglCreateContext(frm.hDC)   'cerco di ottenere un Rendering Context
If (hrc = 0) Then   'se non sono riuscito ad ottenerlo
    KillGLWindow    'elimino il form
    MsgBox "Impossibile ottenere il Rendering Context", vbExclamation, "ERROR"
    CreateGLWindow = False
End If

If wglMakeCurrent(frm.hDC, hrc) = 0 Then    'attivo il Rendering Context
    KillGLWindow    'elimino il form
    MsgBox "Impossibile attivare il Rendering Context", vbExclamation, "ERROR"
    CreateGLWindow = False
End If
frm.Show    'mostro il form
SetForegroundWindow frm.hWnd    'aumento la priorit del programma mettendolo in primo piano
frm.SetFocus    'passo il focus al form (gli eventi tastiera vengono passati al form)
ReSizeGLScene frm.ScaleWidth, frm.ScaleHeight   'setto le dimensioni della scena alle dimensioni del form

If Not InitGL() Then    'inizializzo le OpengL
    'se non sono riuscito ad inizializzare le OpenGL
    KillGLWindow    'elimino il form
    MsgBox "Fallimento dell'inizializzazione delle OpenGL", vbExclamation, "ERROR"  'mostro un avviso di errore
    CreateGLWindow = False
End If
If fullscreen Then  'se la modalit  fullscreen (schermo intero) allora nascondo il cursore e massimizzo la finestra
    HidePointer
    frm.WindowState = vbMaximized
End If
End Function

Public Function DrawGLScene() As Boolean
'questa funzione viene richiamata per disegnare i frame

glClear clrColorBufferBit Or clrDepthBufferBit  'pulisco lo schermo
glLoadIdentity  'resetto le posizioni

glTranslatef 0, -5, -8.5    'sposto la scena in basso e in profondit
glTranslatef 0, 0, -20  'sposto la visuale indietro per permettere una corretta visione della scena
glRotatef 15, 1, 0, 0   'ruoto lo schermo di 15 gradi per migliorare la visione dei mattoncini
glRotatef yrot, 0, 1, 0 'ruoto lo schermo attorno alla scena
yrot = yrot + 0.15  'cambio la rotazione ad ogni frame

glPolygonMode faceFront, pgmFILL

glColor3f 0, 0.4, 0 'setto il colore della base
glTranslatef 0, -0.64, 0    'mi posizione per disegnare la base
glCallList LEGO_base    'disegno la base
glTranslatef 0, 0.64, 0 'annullo lo spostamento effettuato per il disegno della base
DrawBricks  'richiamo la funzione che disegna i mattoncini e che gestisce i vari spostamenti

DrawGLScene = True  'se  andato tutto a buon fine restituisco true (in questo caso questa funzione non  gestita)
End Function

Sub Main()
'questa  la funzione che viene richiamata per prima
Dim Done As Boolean
Dim frm As Form
Dim contatore As Integer

contatore = -1

Done = False

fullscreen = True   'viene settata la modalit a schermo intero(questo  uno sceensaver)

Set frm = New Form1 'si crea il form sul quale verranno disegnate le scene 3D
If Not CreateGLWindow(frm, 640, 480, 16, fullscreen) Then   'il form viene anche inizializzato per l'uso con le OpenGL
    Done = True 'se ci sono stati dei problemi con la creazione della finestra, si esce dal programma direttamente
End If

Do While Not Done   'mainloop ovvero un ciclo quasi infinito che esegue la renderizzazione ed i vari controlli
    If (Not DrawGLScene Or Keys(vbKeyEscape)) Then  'se  stato premuto il tasto esc si esce dal programma (nel mentre viene anche disegnata la scena)
        Unload frm  'il form che mostra la scena viene deallocato
    Else
        If ((bricks(99).visible = True) And (bricks(99).enabled = False)) Then
            'conrollo per determinare se  finita la sequenza di mattoncini
            'in quel caso la sequenza viene mostrata per altri 500 frame e poi viene
            'richiamata la funzione Randomizza che genera un altra lista di mattoncini
            If (contatore = -1) Then
                contatore = 0
            ElseIf (contatore = 500) Then
                Randomizza
                contatore = -1
            Else
                contatore = contatore + 1
            End If
        End If
        SwapBuffers frm.hDC 'scambia i due buffer per mostrare il prossimo frame
        DoEvents    'funzione che passa il controllo al sistema, per permettere la gestione degli eventi sul form (spostamento, chiusura,ecc.)
    End If


    Done = frm.visible = False  'se il form non  visibile esco dal programma
Loop

Set frm = Nothing   'azzero la variabile frm
End 'esco dal programma
End Sub


Public Sub Randomizza()
'questa funzione server per generare i dati casuali dei pezzi
Randomize   'genero un seme casuale basato sull'ora e sulla data
Dim i As Integer
Dim test As Boolean
For i = 0 To 99
    bricks(i).enabled = False
    bricks(i).visible = False
    Do  'setto i colori casuali
        bricks(i).red = CInt(Int((2) * Rnd())) * 0.6
        bricks(i).green = CInt(Int((2) * Rnd())) * 0.6
        bricks(i).blue = CInt(Int((2) * Rnd())) * 0.6
    Loop While (((bricks(i).red = 0) And (bricks(i).green = 0) And (bricks(i).blue = 0)))   'ma impedisco che esca un mattoncino nero
    bricks(i).orientation = CInt(Int((2) * Rnd()))  'genero casualmente l'orientamento del mattoncino
    bricks(i).y = 751   'setto l'altezza di partenza del mattoncino
    
    Do  'questo ciclo serve per evitare un bug che avviene quando due mattoncini con indici seguenti
        'si compenetrano, in quel caso infatti nonostante quasi sempre non si creava nessun problema
        'veniva generato nuovamente un nuovo schema dei mattoncini come se fosse avvenuta una compenetrazione
        test = False
        If (bricks(i).orientation = brick_orientation_z) Then   'genero casualmente le coordinate del pezzo
            bricks(i).x = CInt(Int((7 - (-7) + 1) * Rnd() + (-7)))
            bricks(i).z = CInt(Int((6 - (-6) + 1) * Rnd() + (-6)))
        Else
            bricks(i).x = CInt(Int((6 - (-6) + 1) * Rnd() + (-6)))
            bricks(i).z = CInt(Int((7 - (-7) + 1) * Rnd() + (-7)))
        End If
        
        If (i <> 0) Then    'check di compenetrazione
            If (bricks(i).orientation = bricks(i - 1).orientation) Then
                If ((bricks(i).orientation = brick_orientation_x) And (Abs(bricks(i).x - bricks(i - 1).x) < 4)) Then 'collisione x
                    If (Abs(bricks(i).z - bricks(i - 1).z) < 2) Then 'compenetrazione z
                        test = True
                    End If
                ElseIf ((bricks(i).orientation = brick_orientation_z) And (Abs(bricks(i).x - bricks(i - 1).x) < 2)) Then 'collisione x
                    If (Abs(bricks(i).z - bricks(i - 1).z) < 4) Then 'compenetrazione z
                        test = True
                    End If
                End If
            Else
                If (Abs(bricks(i).x - bricks(i - 1).x) < 3) Then 'compenetrazione x
                    If (Abs(bricks(i).z - bricks(i - 1).z) < 3) Then 'compenetrazione z
                        test = True
                    End If
                End If
            End If
        End If
    Loop While (test = True)
Next i
'abilito il primo mattoncino
bricks(0).visible = True
bricks(0).enabled = True
End Sub

Public Sub DrawxyBrick(x As Integer, z As Integer, size As GLfloat, base As Boolean)
Dim xx As GLfloat
Dim yy As GLfloat
Dim zz As GLfloat
'mi calcolo le dimensioni del mattoncino dimezzate per semplificare i calcoli
xx = (x * 0.8) / 2
yy = size / 2
zz = (z * 0.8) / 2
'disegno il parallelepipedo che far da corpo al mattoncino
glBegin bmQuads
    'disegno la faccia frontale
    glNormal3f 0, 0, 1
    glTexCoord2f 0, 0: glVertex3f -xx, -yy, zz
    glTexCoord2f 1, 0: glVertex3f xx, -yy, zz
    glTexCoord2f 1, 1: glVertex3f xx, yy, zz
    glTexCoord2f 0, 1: glVertex3f -xx, yy, zz
    'disegno il retro
    glNormal3f 0, 0, -1
    glTexCoord2f 1, 0: glVertex3f -xx, -yy, -zz
    glTexCoord2f 1, 1: glVertex3f -xx, yy, -zz
    glTexCoord2f 0, 1: glVertex3f xx, yy, -zz
    glTexCoord2f 0, 0: glVertex3f xx, -yy, -zz
    'disegno la faccia superiore
    glNormal3f 0, 1, 0
    glTexCoord2f 0, 1: glVertex3f -xx, yy, -zz
    glTexCoord2f 0, 0: glVertex3f -xx, yy, zz
    glTexCoord2f 1, 0: glVertex3f xx, yy, zz
    glTexCoord2f 1, 1: glVertex3f xx, yy, -zz
    'disegno la faccia inferiore
    glNormal3f 0, -1, 0
    glTexCoord2f 1, 1: glVertex3f -xx, -yy, -zz
    glTexCoord2f 0, 1: glVertex3f xx, -yy, -zz
    glTexCoord2f 0, 0: glVertex3f xx, -yy, zz
    glTexCoord2f 1, 0: glVertex3f -xx, -yy, zz
    'disegno la faccia destra
    glNormal3f 1, 0, 0
    glTexCoord2f 1, 0: glVertex3f xx, -yy, -zz
    glTexCoord2f 1, 1: glVertex3f xx, yy, -zz
    glTexCoord2f 0, 1: glVertex3f xx, yy, zz
    glTexCoord2f 0, 0: glVertex3f xx, -yy, zz
    'disegno la faccia sinistra
    glNormal3f -1, 0, 0
    glTexCoord2f 0, 0: glVertex3f -xx, -yy, -zz
    glTexCoord2f 1, 0: glVertex3f -xx, -yy, zz
    glTexCoord2f 1, 1: glVertex3f -xx, yy, zz
    glTexCoord2f 0, 1: glVertex3f -xx, yy, -zz
glEnd
'disegno i cilindretti da aggiungere alla faccia superiore del mattoncino
Dim i As Integer
Dim j As Integer
i = 0
j = 0
glTranslatef -(0.4 * (x - 1)), yy, -(0.4 * (z - 1)) 'mi sposto alla base del primo cilindro
'cicli per il disegno dei cilindretti
For i = 1 To z  'ciclo per le colonne
For j = 1 To x  'ciclo per le righe
glRotatef -90, 1, 0, 0  'mi ruoto per disegnare correttamente il cilindro(in realt un tubo perch cavo)
If (base = True) Then
    glColor3f 0, 0.35, 0    'finito ripristino i colori al loro stato originale
End If
gluCylinder quadratic, 0.25, 0.25, 0.17, 10, 1  'disegno il tubo
glTranslatef 0, 0, 0.17 'mi sposto nel punto pi alto del tubo
If (base = True) Then   'coloro in modo differente il disco per chiudere il tubo per rendere pi bella la base
    glColor3f 0, 0.5, 0
End If
gluDisk quadratic, 0, 0.25, 10, 5   'disegno il disco che copre il tubo facendolo sembrare un cilindro
glTranslatef 0, 0, -0.17    'annullo lo spostamento verticale per disegnare il prossimo cilindretto
glRotatef 90, 1, 0, 0   'annullo anche la rotazione
glTranslatef 0.8, 0, 0  'e mi posiziono sul prossimo cilindro
Next j
glTranslatef -0.8 * x, 0, 0.8   'finita una riga mi posiziono all'inizio della riga successiva
Next i
glTranslatef (0.4 * (x - 1)), -yy, -(0.8 * ((z + 1) / 2))   'annullo tutti gli spostamenti eseguiti e mi riposiziono al centro del mattoncino
End Sub

Public Sub DisegnaPezzo(a As brick)
If (a.visible) Then 'se il pezzo  visibile lo disegno
    glColor3f a.red, a.green, a.blue   'setto il colore del mattoncino
    glTranslatef a.x * 0.8, a.y * (0.98 / 50), a.z * 0.8    'mi posiziono nella locazione del mattoncino
    If (a.orientation = brick_orientation_x) Then   'controllo per l'orientamento del mattoncino
        glRotatef 90, 0, 1, 0   'se il mattoncino  allineato all'asse x allora lo ruoto
    End If
    glCallList LEGO_brick
    If (a.orientation = brick_orientation_x) Then   'controllo per l'orientamento del mattoncino
        glRotatef -90, 0, 1, 0  'e dopo annullo la rotazione per far ritornare tutto normale
    End If
    glTranslatef -(a.x * 0.8), -(a.y * (0.98 / 50)), -(a.z * 0.8)   'annullo gli spostamenti e mi riposiziono nell'origine
End If
End Sub

Public Function brickTouch(a As Integer, b As Integer)
'questa funzione  il "motore fisico" del programma, ovvero  quella che calcola
'quando avviene una collisione o una compenetrazione tra due pezzi e lo segnala alla
'funzione DrawBricks

brickTouch = 0
'check di collisione  tra due pezzi
If (Abs(bricks(a).y - bricks(b).y) = 50) Then   'collisione y
    If (bricks(a).orientation = bricks(b).orientation) Then
        If ((bricks(a).orientation = brick_orientation_x) And (Abs(bricks(a).x - bricks(b).x) < 4)) Then 'collisione x
            If (Abs(bricks(a).z - bricks(b).z) < 2) Then 'collisione z
                brickTouch = 1
            End If
        ElseIf ((bricks(a).orientation = brick_orientation_z) And (Abs(bricks(a).x - bricks(b).x) < 2)) Then 'collisione x
            If (Abs(bricks(a).z - bricks(b).z) < 4) Then 'collisione z
                brickTouch = 1
            End If
        End If
    Else
        If (Abs(bricks(a).x - bricks(b).x) < 3) Then 'collisione x
            If (Abs(bricks(a).z - bricks(b).z) < 3) Then 'collisione z
                brickTouch = 1
            End If
        End If
    End If
End If
If (a = b) Then
    brickTouch = 0
Else    'check di compenetrazione tra due pezzi
    If (Not ((bricks(a).y = bricks(b).y) And (bricks(a).y = 701))) Then
        If (Abs(bricks(a).y - bricks(b).y) < 50) Then   'collisione y
            If (bricks(a).orientation = bricks(b).orientation) Then
                If ((bricks(a).orientation = brick_orientation_x) And (Abs(bricks(a).x - bricks(b).x) < 4)) Then 'collisione x
                    If (Abs(bricks(a).z - bricks(b).z) < 2) Then 'collisione z
                        brickTouch = 2
                    End If
                ElseIf ((bricks(a).orientation = brick_orientation_z) And (Abs(bricks(a).x - bricks(b).x) < 2)) Then 'collisione x
                    If (Abs(bricks(a).z - bricks(b).z) < 4) Then 'collisione z
                        brickTouch = 2
                    End If
                End If
            Else
                If (Abs(bricks(a).x - bricks(b).x) < 3) Then 'collisione x
                    If (Abs(bricks(a).z - bricks(b).z) < 3) Then 'collisione z
                        brickTouch = 2
                    End If
                End If
            End If
    End If
    End If
End If
End Function

Public Sub DrawBricks()
Dim i As Integer
Dim k As Integer
i = 0
Do
    If (bricks(i).enabled) Then 'se il mattoncino  abilitato oltre che visibile parto con lo spostamento e con i controlli
        bricks(i).y = bricks(i).y - 1
        If (bricks(i).y = 0) Then   'se il mattoncino  arrivato a toccare la base verde
            bricks(i).enabled = False   'lo fermo
            bricks(i + 1).enabled = True    'e attivo il mattoncino successivo
            bricks(i + 1).visible = True
        Else
            k = -1
            Do  'ciclo per controllare che il mattoncino non sia in contatto con un altro mattoncino
                'o che non sia compenetrato in caso di un mattoncino appena generato
                k = k + 1
            Loop While ((bricks(k).visible = True) And (k < 100) And (brickTouch(i, k) = 0))    'non mi serve controllare mattoncini che non sono visibili
            If ((bricks(k).visible = True) And (k < 100) And (brickTouch(i, k) = 1)) Then   'se il mattoncino  entrato in contatto con un altro mattoncino
                bricks(i).enabled = False   'lo fermo
                bricks(i + 1).enabled = True    'e avvio il successivo
                bricks(i + 1).visible = True
            End If
            If ((brickTouch(i, k) = 2) And (bricks(99).visible = False)) Then   'se invece  compenetrato con un altro mattoncino
                'vuol dire che la torre  piena quindi devo generare un altra sequenza di mattoncini e farla partire
                bricks(i).visible = False   'nascondo il mattoncino preso in considerazione per nascondere il glitch grafico
                bricks(99).visible = True   'rendo visibile l'ultimo mattoncino
                bricks(99).enabled = False  'ma lo disabilito
                                            'questo grazie ad un controllo nel mainloop mi porta a rendererizzare altri 500 frame
                                            'e poi a generare un altra sequenza di mattoncini grazie al richiamo della funzione Randomizza
                bricks(99).y = 900  'posiziono l'ultimo mattoncino in una posizione non visibile in modo da non creare eventuali glitch grafici
            End If
        End If
    End If
    DisegnaPezzo bricks(i)  'disegno il pezzo
    i = i + 1
Loop While ((bricks(i).visible = True) And (i < 100))   'ciclo finch non sono arrivato al centesimo pezzo (indice 99) o finch non sono arrivato ad un pezzo invisibile
End Sub

Public Sub InitDisplayList()
'questa funzione mi serve per inizializzare le display list
'quando viene inserito un elemento in una display list le istruzioni vengono ottimizzate
'e quando la scheda video lo permette le informazioni vengono salvate nella sua memoria
'per permettere una renderizzazione molto pi rapida

LEGO_brick = glGenLists(1)  'creo la display list che contine i mattoncini lego
glNewList LEGO_brick, lstCompile
    DrawxyBrick 2, 4, brick_size_normal, False
glEndList

LEGO_base = glGenLists(1)   'creo la display list che contine la base
glNewList LEGO_base, lstCompile
    DrawxyBrick 16, 16, brick_size_flat, True
glEndList

End Sub

